/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIDumpDataBean;
import com.ibm.hsc.client.PIHMCStringDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCSysClient;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.File;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIQueryDumpCommand {
    private static final String NAME_FORMAT = "name";
    private static final String SIZE_FORMAT = "size";
    private static final String dumpDirName = "/dump/";
    private static final int NUM_VALID_PARMS = 6;
    private boolean m_header;
    private String m_format;
    private String m_managedSystem;
    private String m_hmc;
    private String m_frame;
    private String m_side;
    private HashMap m_validParms = new HashMap(13, 0.5f);
    private String m_delimiter = ",";
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFrameClient m_FrameClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIQueryDumpCommand(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_FrameClient = pIHSCFrameClient;
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put("-h", null);
        this.m_validParms.put("-e", null);
        this.m_validParms.put("-s", null);
    }

    private void queryHMCDumps() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = null;
        Vector<PIHMCStringDataBean> vector = new Vector<PIHMCStringDataBean>();
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
        String[] stringArray3 = new String[]{NAME_FORMAT, SIZE_FORMAT};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray3, stringArray3.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray2 = PICmdOutputUtils.checkKeys(stringArray3, this.m_format, this.m_delimiter);
        } else {
            stringArray2 = stringArray3;
        }
        File file = new File(dumpDirName);
        if (file.exists() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(dumpDirName + stringArray[i]);
                String string = file2.getName();
                if (!file2.isFile() || !string.startsWith("SYSDUMP") && !string.startsWith("FSPDUMP") && !string.startsWith("SMADUMP") && !string.startsWith("PWRDUMP")) continue;
                PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(stringArray3);
                pIHMCStringDataBean.setKeyValue(NAME_FORMAT, string);
                pIHMCStringDataBean.setKeyValue(SIZE_FORMAT, String.valueOf(file2.length()));
                vector.add(pIHMCStringDataBean);
            }
        }
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray2, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private PIHSCSysClient createSysClient() throws PIHscClientException {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        PIHSCSysClient pIHSCSysClient = null;
        if (this.m_CECClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this.m_managedSystem, false, 0);
        } else if (this.m_FrameClient != null) {
            pIHSCSysClient = pIHSCClientObjectFactory.createSysClient(this.m_frame, false, 1);
        }
        if (null == pIHSCSysClient) {
            if (this.m_CECClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8002", null, null);
            }
            if (this.m_FrameClient == null) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8001", null, null);
            }
            return null;
        }
        return pIHSCSysClient;
    }

    private void doQueryDump() throws PIHscClientException {
        String[] stringArray = null;
        Vector vector = null;
        String[] stringArray2 = null;
        String string = "PRIMARY";
        PIHSCSysClient pIHSCSysClient = this.createSysClient();
        if (pIHSCSysClient != null) {
            if (this.m_frame != null && "a".equals(this.m_side)) {
                string = "SIDE_A";
            } else if (this.m_frame != null && "b".equals(this.m_side)) {
                string = "SIDE_B";
            }
            stringArray2 = pIHSCSysClient.queryDump(string);
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
        if (stringArray2 != null) {
            vector = this.buildBeanVector(stringArray2);
        }
        String[] stringArray3 = new String[]{"dump_type"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray3, stringArray3.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray3, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray3;
        }
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private Vector buildBeanVector(String[] stringArray) {
        Vector<PIDumpDataBean> vector = new Vector<PIDumpDataBean>();
        PIDumpDataBean pIDumpDataBean = null;
        if (stringArray.length < 4) {
            return vector;
        }
        if (!stringArray[1].equals("0")) {
            pIDumpDataBean = new PIDumpDataBean();
            pIDumpDataBean.setDumpType("sys");
            vector.add(pIDumpDataBean);
        }
        if (!stringArray[2].equals("0")) {
            pIDumpDataBean = new PIDumpDataBean();
            pIDumpDataBean.setDumpType("sp");
            vector.add(pIDumpDataBean);
        }
        if (!stringArray[3].equals("0")) {
            pIDumpDataBean = new PIDumpDataBean();
            pIDumpDataBean.setDumpType("pss");
            vector.add(pIDumpDataBean);
        }
        return vector;
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        if (this.m_hmc != null) {
            this.queryHMCDumps();
        } else {
            PICECDataBean pICECDataBean;
            int n;
            if (this.m_CECClient != null && ((n = (pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"})).getCecState().intValue()) == 254 || n == 241 || n == 242 || n == 250)) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
            }
            this.doQueryDump();
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_hmc != null) {
            if (!this.m_hmc.equals("")) {
                String[] stringArray = new String[]{"-h " + this.m_hmc};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
            if (this.m_managedSystem != null) {
                String[] stringArray = new String[]{"[-m | -h]"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
            }
            if (this.m_frame != null) {
                String[] stringArray = new String[]{"[-e | -h]"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
            }
        }
        if (!(this.m_managedSystem != null && this.m_managedSystem.length() != 0 || this.m_frame != null && this.m_frame.length() != 0 || this.m_hmc != null)) {
            string = ", -m | -e | -h";
        }
        if (this.m_frame != null && (this.m_side == null || !"a".equals(this.m_side.toLowerCase()) && !"b".equals(this.m_side.toLowerCase()))) {
            string = string + ", -s";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_frame == null && this.m_side != null) {
            String[] stringArray = new String[]{"-s"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_COMBINATION", stringArray, null);
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_hmc = (String)hashMap.get("-h");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
        this.m_frame = (String)hashMap.get("-e");
        this.m_side = (String)hashMap.get("-s");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSDUMP_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIQueryDumpCommand pIQueryDumpCommand = new PIQueryDumpCommand(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIQueryDumpCommand.m_validParms);
            pIQueryDumpCommand.mapParameters(hashMap);
            pIQueryDumpCommand.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

